    @extends('admin.layouts.app')

    @section('title', 'Data Jadwal Shift')

    @section('content')

        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h4 class="fw-bold mb-1">Data Jadwal Shift</h4>
                <small class="text-muted">Manajemen jadwal shift</small>
            </div>

            <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal"
                data-bs-target="#tambahJadwal">
                <i class="fas fa-plus me-2"></i>Tambah Data
            </button>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-body">

                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Departemen</th>
                            <th>Shift</th>
                            <th>Tanggal Mulai</th>
                            <th>Tanggal Selesai</th>
                            <th>LStatus</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($jadwalShift as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->departemen->nama }}</td>
                                <td>
                                    {{ $item->shift->kode }}
                                    <small class="text-muted d-block">
                                        {{ substr($item->shift->jam_masuk, 0, 5) }}
                                        -
                                        {{ substr($item->shift->jam_pulang, 0, 5) }}
                                    </small>
                                </td>

                                {{-- <td>
                                    <span class="badge bg-info text-dark">
                                        {{ $item->role }}
                                    </span>
                                </td> --}}
                                <td>{{ $item->tanggal_mulai ?? '-' }}</td>
                                <td>{{ $item->tanggal_selesai ?? '-' }}</td>
                                <td>{{ $item->is_active }}</td>

                                <td class="text-center">
                                    <button data-bs-target="#ubahJadwal{{ $item->id }}" data-bs-toggle="modal"
                                        class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                        data-bs-target="#hapusJadwal{{ $item->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
            @foreach ($shift as $item)
                @include('admin.jadwal-shift.edit')
                {{-- @include('admin.jadwal-shift.delete') --}}
            @endforeach
        </div>
        @include('admin.jadwal-shift.create')


    @endsection
